﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using SMCSMicroReceipt;
using System.Drawing.Printing;

namespace SMCSMicroReceipt_Sample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Set_button_Click(object sender, EventArgs e)
        {

            SMCSMicroReceiptSetting smcs = new SMCSMicroReceiptSetting();

            SMCSMicroReceiptSetting.SMCSMicroReceiptResult result;

            result = smcs.SetMicroReceiptType(PrinterName_text.Text, (SMCSMicroReceiptSetting.SMCSMicroReceiptType)SMCSMicroReceipt_comboBox.SelectedIndex);

            if (result == SMCSMicroReceiptSetting.SMCSMicroReceiptResult.SUCCESS)
            {

                try
                {
                    //Check existence of printer queue
                    foreach (string printerQueuName in System.Drawing.Printing.PrinterSettings.InstalledPrinters)
                    {
                        if (printerQueuName.Equals(PrinterName_text.Text))
                        {
                            //Print Test
                            string parameters = "printui.dll,PrintUIEntry /k /n " + "\"" + PrinterName_text.Text + "\"";
                            System.Diagnostics.Process.Start("rundll32.exe", parameters);
                        }
                    }

                }
                catch (Exception)
                {

                }

                MessageBox.Show("Success", "Result");
            }
            else
            {
                ShowFailureMessage(result);
            }


        }


        private void Get_button_Click(object sender, EventArgs e)
        {

            SMCSMicroReceiptSetting smcs = new SMCSMicroReceiptSetting();

            SMCSMicroReceiptSetting.SMCSMicroReceiptType type;

            SMCSMicroReceiptSetting.SMCSMicroReceiptResult result;

            result = smcs.GetMicroReceiptType(PrinterName_text.Text, out type);

            if (result == SMCSMicroReceiptSetting.SMCSMicroReceiptResult.SUCCESS) { ShowMessage(type); }
            else { ShowFailureMessage(result); }


        }

        private void ShowMessage(SMCSMicroReceiptSetting.SMCSMicroReceiptType type)
        {
            string messsage = "";
            switch (type)
            {
                case SMCSMicroReceiptSetting.SMCSMicroReceiptType.DISABLE:
                    messsage = "Disable";
                    break;
                case SMCSMicroReceiptSetting.SMCSMicroReceiptType.INFORMATION_WITH_QRCODE:
                    messsage = "Information Logo + QR code";
                    break;
                case SMCSMicroReceiptSetting.SMCSMicroReceiptType.ONLY_QRCODE:
                    messsage = "QR code";
                    break;
                case SMCSMicroReceiptSetting.SMCSMicroReceiptType.ONDEMAND_INFORMATION_WITH_QRCODE:
                    messsage = "Ondemand Information Logo + QR code";
                    break;
                case SMCSMicroReceiptSetting.SMCSMicroReceiptType.ONDEMAND_ONLY_QRCODE:
                    messsage = "Ondemand QR code";
                    break;
            }

            MessageBox.Show(messsage, "Result");
        }

        private void ShowFailureMessage(SMCSMicroReceiptSetting.SMCSMicroReceiptResult result)
        {
            string messsage = "";
            switch (result)
            {
                case SMCSMicroReceiptSetting.SMCSMicroReceiptResult.SMCS_NOT_REGISTERED:
                    messsage = "Failure - SMCS_NOT_REGISTERED";
                    break;
                case SMCSMicroReceiptSetting.SMCSMicroReceiptResult.PRINTER_NAME_NOT_FOUND:
                    messsage = "Failure - PRINTER_NAME_NOT_FOUND";
                    break;
                case SMCSMicroReceiptSetting.SMCSMicroReceiptResult.MICRORECEIPT_PARMETER_NOT_FOUND:
                    messsage = "Failure - MICRORECEIPT_PARMETER_NOT_FOUND";
                    break;
                case SMCSMicroReceiptSetting.SMCSMicroReceiptResult.SETTING_VALUE_IS_INCORRECT:
                    messsage = "Failure - SETTING_VALUE_IS_INCORRECT";
                    break;
                case SMCSMicroReceiptSetting.SMCSMicroReceiptResult.INITIALIZE_ERROR:
                    messsage = "Failure - INITIALIZE_ERROR";
                    break;
                case SMCSMicroReceiptSetting.SMCSMicroReceiptResult.XML_FILE_NOT_BE_LOADED:
                    messsage = "Failure - XML_FILE_NOT_BE_LOADED";
                    break;
                case SMCSMicroReceiptSetting.SMCSMicroReceiptResult.TIMEOUT:
                    messsage = "Failure - TIMEOUT";
                    break;
                default:
                    messsage = result.ToString();
                    break;
            }

            MessageBox.Show(messsage, "Result");
        }

    }
}
